from collections import defaultdict

def total_greetings(n, points):
    # Mapa za pracenje broja takmicara na svakoj tacki
    count_map = defaultdict(int)
    # Kolicina pozdrava
    greetings = 0
    
    # Simulirajmo kretanje takmicara
    for x, y in points:
        # Generišemo pocetne pozicije za sve 4 takmicare (sever, jug, istok, zapad)
        positions = [
            (x, y + 1),  # Istok
            (x, y - 1),  # Zapad
            (x + 1, y),  # Sever
            (x - 1, y)   # Jug
        ]
        
        # Dodajemo takmicare na mape za pozdrave
        for pos in positions:
            count_map[pos] += 1

    # Broj pozdrava
    for count in count_map.values():
        if count > 1:
            greetings += (count * (count - 1)) // 2  # Kombinacija (k * (k-1)) // 2
    
    return greetings

# Ulazni podaci
n = int(input())
points = [tuple(map(int, input().split())) for _ in range(n)]

# Pozivanje funkcije
result = total_greetings(n, points)

# Ispis rezultata
print(result)